<?php

/**
 * This is the model class for table "PunktyDziedzinyFirmy".
 *
 * The followings are the available columns in table 'PunktyDziedzinyFirmy':
 * @property double $idDziedziny
 * @property string $nazwa
 * @property double $punkty
 * @property double $idFirmy
 */
class PunktyDziedzinyFirmy extends CActiveRecord
{
	/**
	 * Returns the static model of the specified AR class.
	 * @param string $className active record class name.
	 * @return PunktyDziedzinyFirmy the static model class
	 */
	public static function model($className=__CLASS__)
	{
		return parent::model($className);
	}

	/**
	 * @return string the associated database table name
	 */
	public function tableName()
	{
		return 'PunktyDziedzinyFirmy';
	}

	/**
	 * @return array validation rules for model attributes.
	 */
	public function rules()
	{
		return array(
			array('punkty', 'numerical'),
			array('nazwa', 'length', 'max'=>128),

			array('idDziedziny, nazwa, punkty, idFirmy', 'safe', 'on'=>'search'),
		);
	}

	/**
	 * @return array relational rules.
	 */
	public function relations()
	{
		return array(
			'dziedzina'=>array(self::BELONGS_TO, 'Dziedzina', 'idDziedziny'),
		);
	}

	/**
	 * @return array customized attribute labels (name=>label)
	 */
	public function attributeLabels()
	{
		return array(
			'idDziedziny'=>Yii::t('PunktyDziedzinyFirmy', 'idDziedziny'),
			'nazwa'=>Yii::t('PunktyDziedzinyFirmy', 'nazwa'),
			'punkty'=>Yii::t('PunktyDziedzinyFirmy', 'punkty'),
			'idFirmy'=>Yii::t('PunktyDziedzinyFirmy', 'idFirmy'),
		);
	}

	/**
	 * Retrieves a list of models based on the current search/filter conditions.
	 * @return CActiveDataProvider the data provider that can return the models based on the search/filter conditions.
	 */
	public function search()
	{
		$criteria = new CDbCriteria;

		$criteria->compare('idDziedziny', $this->idDziedziny);
		$criteria->compare('nazwa', $this->nazwa, true);
		$criteria->compare('punkty', $this->punkty);
		$criteria->compare('idFirmy', $this->idFirmy);

		return new CActiveDataProvider($this, array(
			'criteria'=>$criteria,
		));
	}
}